import java.util.concurrent.BlockingQueue;

class ProThread extends Thread {
	private final BlockingQueue<Integer> depot;
	private final int[] produkte = {1, 2, 3};
	private final Thread kon;
	
	ProThread(BlockingQueue<Integer> dep, Thread kon) {
		depot = dep;
		this.kon = kon;
	}

	@Override
	public void run() {
		try {
			for (int i = 0; i < produkte.length; i++) {
				System.out.println("\nDer Produzent liefert gleich.");
				depot.add(produkte[i]);
				sleep(10);
				System.out.println("Kurz nach der Lieferung ist der Konsument " + kon.getState());
				sleep(5000);
				System.out.println("Produzent wacht auf, Konsument ist " + kon.getState());
			}
		} catch (InterruptedException ie) {
			// Ignorieren ist OK, weil kein Interrupt signalisiert wird.
		}
	}
}